/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.debugger;

import emulator.shell.GUI.debugger.LineMetrics;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ScrollView
extends JPanel {
    private Font font = new Font("Monospaced", 0, 12);
    private int border = 3;
    private LineMetrics line_metrics = new LineMetrics();
    private JScrollBar scroll_bar;
    ScrollPane scroll_pane = null;

    boolean isPanelActive() {
        throw new NotImplementedException();
    }

    void setCurrentPosition(int desired_position) {
        throw new NotImplementedException();
    }

    int getCurrentPosition() {
        throw new NotImplementedException();
    }

    void setCurrentRange(int current_range) {
        throw new NotImplementedException();
    }

    int getCurrentRange() {
        throw new NotImplementedException();
    }

    void setVisibleLines(int i) {
        throw new NotImplementedException();
    }

    int getVisibleLines() {
        throw new NotImplementedException();
    }

    public Font getTextFont() {
        return this.font;
    }

    public int getBorderSize() {
        return this.border;
    }

    public LineMetrics getLineMetrics() {
        return this.line_metrics;
    }

    public ScrollPane getScrollPane() {
        return this.scroll_pane;
    }

    public void initScrollBar() {
        this.scroll_bar = new JScrollBar(1);
        this.scroll_bar.addAdjustmentListener(new ScrollBarListener());
        this.scroll_bar.setValues(this.getCurrentPosition(), this.getVisibleLines(), 0, this.getCurrentRange());
        this.scroll_bar.setEnabled(false);
        this.add((Component)this.scroll_bar, "East");
    }

    public void showScrollBar(boolean show) {
        this.scroll_bar.setEnabled(show);
    }

    public void ensureVisible(int index, boolean update) {
        if (!this.isVisibleLine(index)) {
            this.moveTo(index - this.getVisibleLines() / 2, update);
        }
    }

    boolean isVisibleLine(int index) {
        return this.getCurrentPosition() <= index && index < this.getCurrentPosition() + this.getVisibleLines();
    }

    private void adjustScrollBar() {
        this.scroll_bar.setValues(this.getCurrentPosition(), this.getVisibleLines(), 0, this.getCurrentRange());
        this.scroll_bar.setValueIsAdjusting(true);
    }

    private void moveTo(int desired_position, boolean update) {
        if (this.isPanelActive()) {
            this.setCurrentPosition(desired_position);
            if (update) {
                this.repaint();
            }
        }
    }

    public int hitTest(Point point) {
        int line_rel;
        if (this.isPanelActive() && (line_rel = (point.y - this.getBorderSize()) / this.getLineMetrics().getLineHeight()) >= 0 && line_rel < this.getVisibleLines()) {
            return this.getCurrentPosition() + line_rel;
        }
        return -1;
    }

    @Override
    public void paint(Graphics g) {
        if (this.isPanelActive()) {
            this.getScrollPane().calcVisibleLines();
            this.adjustScrollBar();
        }
        super.paint(g);
    }

    class KeyboardListener
    implements KeyListener {
        KeyboardListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 33: {
                    ScrollView.this.moveTo(ScrollView.this.getCurrentPosition() - ScrollView.this.getVisibleLines() + 1, true);
                    break;
                }
                case 34: {
                    ScrollView.this.moveTo(ScrollView.this.getCurrentPosition() + ScrollView.this.getVisibleLines() - 1, true);
                    break;
                }
                case 35: {
                    ScrollView.this.moveTo(Integer.MAX_VALUE, true);
                    break;
                }
                case 36: {
                    ScrollView.this.moveTo(0, true);
                    break;
                }
                case 38: {
                    ScrollView.this.moveTo(ScrollView.this.getCurrentPosition() - 1, true);
                    break;
                }
                case 40: {
                    ScrollView.this.moveTo(ScrollView.this.getCurrentPosition() + 1, true);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    class MouseScrollListener
    implements MouseWheelListener {
        MouseScrollListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            ScrollView.this.moveTo(ScrollView.this.getCurrentPosition() + event.getUnitsToScroll(), true);
        }
    }

    class ScrollBarListener
    implements AdjustmentListener {
        ScrollBarListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            ScrollView.this.moveTo(event.getValue(), true);
        }
    }

    public class ScrollPane
    extends JPanel {
        protected void printString(Graphics g, String s, int x, int y) {
            this.printString(g, s, x, y, new Rectangle());
        }

        protected void printString(Graphics g, String s, int x, int y, Rectangle bounding_rect) {
            this.getBoundingRect(s, x, y, bounding_rect);
            g.drawString(s, bounding_rect.x, bounding_rect.y);
        }

        protected void getBoundingRect(String s, int x, int y, Rectangle bounding_rect) {
            FontMetrics fn = this.getFontMetrics(ScrollView.this.getTextFont());
            bounding_rect.x = (fn.stringWidth("M") + 1) * x + ScrollView.this.border;
            bounding_rect.height = fn.getHeight();
            bounding_rect.y = bounding_rect.height * (y + 1) - fn.getMaxDescent() + ScrollView.this.border;
            bounding_rect.width = fn.stringWidth(s);
        }

        protected int getTextWidth(int dx) {
            FontMetrics fn = this.getFontMetrics(ScrollView.this.getTextFont());
            return (fn.stringWidth("M") + 1) * dx;
        }

        public void calcVisibleLines() {
            FontMetrics fn = this.getFontMetrics(ScrollView.this.getTextFont());
            Rectangle rec = this.getBounds();
            ScrollView.this.line_metrics.setLineWidth(rec.width - 2 * ScrollView.this.border);
            ScrollView.this.line_metrics.setLineHeight(fn.getHeight());
            ScrollView.this.setVisibleLines((rec.height - 2 * ScrollView.this.border) / ScrollView.this.line_metrics.getLineHeight());
        }

        public int hitTest(Point point) {
            int line_rel;
            if (ScrollView.this.isPanelActive() && (line_rel = (point.y - ScrollView.this.border) / ScrollView.this.line_metrics.getLineHeight()) >= 0 && line_rel < ScrollView.this.getVisibleLines()) {
                return ScrollView.this.getCurrentPosition() + line_rel;
            }
            return -1;
        }
    }
}

